<?php 
#   Copyright by Manuel Staechele
#   Support www.ilch.de


defined ('main') or die ( 'no direct access' );

class tpl
{
	var $parts;
	var $keys;
	var $lists;
	var $lang;
	
	function tpl ($file) {
	  
		$this->parts = array();
		$this->keys = array();
		$this->lists = array();
		$this->lang = array();
    
		# check if design 
		if ( substr ( $file , 0 , 15 ) != 'include/designs' )  {
		  $file = 'include/templates/'.$file;
		}
		if ( substr ( $file , strlen ( $file ) - 4  , strlen ($file) -1 ) != '.htm' ) {
		  $file = $file.'.htm';
		}
		
	  $inhalt = implode("", file($file) );
		
		global $lang;
		$this->lang = $lang;
		$inhalt = $this->replace_lang($inhalt);
		
		$inhalt = $this->replace_list($inhalt);
		$this->parts = explode ( '{EXPLODE}', $inhalt );
	}
	
	function replace_lang ( $var ) {
		$lang_zwischenspeicher = array();
		preg_match_all ("/\{_lang_([^\{\}]+)\}/" , $var , $lang_zwischenspeicher);
    foreach ( $lang_zwischenspeicher[1] as $v ) {
      $var = str_replace('{_lang_'.$v.'}',$this->lang[$v],$var);
    }
		return ( $var );
	}
	
	function replace_list ( $var ) {
		$zwischenspeicher = array();
		preg_match_all ("/\{_list_([^\{\}]+)\}/" , $var , $zwischenspeicher);
    foreach ( $zwischenspeicher[1] as $v ) {
			list ( $key , $val ) = explode('@',$v);
		  $this->lists[$key] = $val;
			$var = str_replace('{_list_'.$v.'}','{'.$key.'}',$var);
    }
		return ( $var );
	}
	
	function list_get ( $key , $ar ) {
	  $zwischenspeicher = $this->lists[$key];
	  foreach ( $ar as $k => $v ) {
		  $i = $k + 1;
		  $zwischenspeicher = str_replace('%'.$i,$v,$zwischenspeicher);
		}
		return ( $zwischenspeicher );
	}
	
	function list_exists ( $key ) {
	  if ( isset ( $this->lists[$key] ) ) {
		  return ( true );
		} else {
		  return ( false );
		}
	}
	
	function list_out ( $key , $ar ) {
	  echo $this->list_get ( $key , $ar );
	}
	
	function set ($k , $v) {
		#$this->keys[$k] = unescape($v);
		$this->keys[$k] = $v;
	}
	
	function set_ar ($ar) {
		foreach ($ar as $k => $v) {
		  #$this->keys[$k] = unescape($v);
			$this->keys[$k] = $v;
		}
	}
	
	function set_ar_out ( $ar , $pos ) {
	  $this->set_ar($ar);
		$this->out($pos);
	}
	
	function set_out ( $k , $v , $pos ) {
	  $this->set($k , $v);
		$this->out($pos);
	}
	
	function set_ar_get ( $ar , $pos ) {
	  $this->set_ar($ar);
		return ( $this->get($pos) );
	}
	
	function set_get ( $k , $v , $pos ) {
	  $this->set($k , $v);
		return ( $this->get($pos) );
	}
	
	function del ($k) {
	  unset ($this->keys[$k]);
	}
	
	function del_ar ($ar) {
	  foreach ($ar as $k => $v) {
		  unset ($this->keys[$k]);
		}
	}
	
	function get ($pos) {
	  $toout = $this->parts[$pos];
    foreach ( $this->keys as $k => $v ) {
		  $toout = str_replace( '{'.$k.'}' , $v , $toout );
		}
		return ($toout);
	}
	
	function out ($pos) {
	  echo $this->get ($pos);
	}
}
?>
