<?php
/**
 * Captcha fr www.ilch.de
 * @author T0P0LIN0
 * thanks to uwe slick! http://www.deruwe.de/captcha.html - his thoughts
 */

/**
 * MemorySession
 * Speichern der Zahlen fr das Captcha in der Session
 *
 * @author Mairu
 */
class MemorySession
{
    /**
     * Initialisiert Session
     * 
     * @param boolean $startSession session_start wird ausgefhrt
     * @param string $sessionId SessionId die dabei verwendet wird
     */
    function MemorySession($startSession = true, $sessionId = 'sid')
    {
        if ($startSession) {
            session_name($sessionId);
            session_start();
        }
        if (!isset($_SESSION['antispam_numbers'])) {
            $_SESSION['antispam_numbers'] = array();
        } else {
            $this->updateMemory();
        }
    }

    /**
     * Prft, ob bergebener CaptchaCode zur angegeben Id gefunden wird
     * 
     * @param string $captchaCode
     * @param string $captchaId
     * @return boolean
     */
    function checkCode($captchaCode, $captchaId)
    {
        if (isset($_SESSION['antispam_numbers'][$captchaId])
            && $_SESSION['antispam_numbers'][$captchaId]['captcha_code'] == $captchaCode
        ) {
            unset($_SESSION['antispam_numbers'][$captchaId]);
            return true;
        }
        return false;
    }

    /**
     * Lscht alte Eintrge aus dem Speicher
     */
    function updateMemory()
    {
        $tooOld = time() - 60 * 30; //30 Minuten
        foreach ($_SESSION['antispam_numbers'] as $captchaId => $values) {
            if ($tooOld > $values['time']) {
                unset($_SESSION['antispam_numbers'][$captchaId]);
            }
        }
    }

    /**
     * Legt neuen Eintrag fr einen Captchacode mit Id an im Speicher an
     * 
     * @param string $captchaCode
     * @param string $captchaId
     */
    function saveCode($captchaCode, $captchaId)
    {
        $_SESSION['antispam_numbers'][$captchaId] = array(
                'captcha_code' => $captchaCode,
                'time' => time()
        );
    }
}
