<?php

########################################################
#                                                      #
#   Inactive User Manager  v2.3                        #
#    2014 by Outi77 & LordOfDeath                     #
#     Code Anpassung & Optimierung: Mairu              #
#   ------------------------------------------------   #
#   Support: www.ilch.de                               #
#   ------------------------------------------------   #
#   Homepage: Outi77       (www.sivos.de)              #
#             LordOfDeath  (www.altehasen-gaming.de)   #
#             Mairu        (www.mairu.ilch.de)         #
#                                                      #
########################################################

defined ('main') or die ('no direct access');
defined ('admin') or die ('only admin access');

require_once 'include/includes/func/inactiveuserfunc.php';

$tpl = new tpl ('userwarns', 1);

function change_grecht_immun($grechtid) {
    $resp = new xajaxResponse();
    
    $grechtid = escape($grechtid, 'integer');
    $grechtname = db_result(db_query("SELECT name FROM prefix_grundrechte WHERE id = ".$grechtid));
    //$grechtname = db_fetch_assoc($abf_grechtname);
    
    //alle user mit diesem recht
    $user_grecht = array(); $user_grecht_immun = array();
    $abf_user_grecht = db_query("SELECT u.id, u.recht, uw.uid
                                    FROM prefix_user as u
                                    LEFT JOIN prefix_user_warn as uw on u.id = uw.uid
                                    WHERE u.recht = ".$grechtid);
    while ($erg_user_grecht = db_fetch_assoc($abf_user_grecht)) {
        $user_grecht[] = $erg_user_grecht['id'];
        if (db_result(db_query("SELECT COUNT(immunid) FROM prefix_user_warn_immun WHERE immunid = ".$erg_user_grecht['id'])) > 0) {
            $user_grecht_immun[] = $erg_user_grecht['id'];
        }
    }
    
    //wenn grundrecht nicht immun
    if (0 == db_num_rows(db_query("SELECT id FROM prefix_user_warn_immun WHERE immunid = ".$grechtid." AND typ = 'grundrecht'"),0)) {
        //immun setzen
        if (db_query("INSERT INTO prefix_user_warn_immun (immunid, typ, adname, komm, time) VALUES (".$grechtid.",'grundrecht','".$_SESSION['authname']."','Grundrecht',".time().")")) {
            //jeden user mit diesem grecht aus warn-tabelle entfernen
            db_query("DELETE FROM prefix_user_warn WHERE uid IN(SELECT id FROM prefix_user WHERE recht = ".$grechtid.")");
            //hier jetzt im tab bersicht alle tr der betroffenen user unsichtbar machen
            $resp->call('hide_user', $user_grecht);
            //bei hndisch immunen usern, die jetzt auch per recht immun sind, das twice-icon sichtbar machen
            $resp->call('show_twice_icon', $user_grecht_immun, $grechtname);
        } else {
            $resp->alert("Fehler aufgetreten:\n" . mysql_error());
        }
    } else {
        //de-immunisieren
        if (db_query("DELETE FROM prefix_user_warn_immun WHERE immunid = ".$grechtid." AND typ = 'grundrecht'")) {
            foreach ($user_grecht as $key=>$value) {
                $resp->script("document.querySelector('#twice-immun-icon-'+$value).style.display = 'none';");
            }
        } else {
            $resp->alert("Fehler aufgetreten:\n" . mysql_error());
        }
    }
    //wenn Warn-Tabelle leer, Platzhalter einblenden
    if (0 == db_num_rows(db_query("SELECT uid FROM prefix_user_warn WHERE uid > 0"))) {
        $resp->script("document.querySelector('#warnlist_no_entry').style.display = '';");
    }
    return $resp;
}

// xajax
$xajax = new xajax();
$xajax->configureMany(array('decodeUTF8Input' => true ,'characterEncoding' => 'ISO-8859-1', 'requestURI' => 'admin.php?userwarns-ajax'));

$xajax->register(XAJAX_FUNCTION, 'change_grecht_immun');
$xajax->processRequest();

$design = new design ('Admins Area', 'Admins Area', 2);
$design->addheader('<link rel="stylesheet" href="include/includes/css/userwarns.css" media="all" type="text/css">'); //css
$design->addtobodyend('<script type="text/javascript" src="include/includes/js/userwarns.js"></script>'); //javascript
$design->header();

$no_inactive_opt = db_result(db_query("SELECT nowarn_inactive FROM prefix_user_warn_conf"));

//Array mit allen Teams und zugehrigen Mitglieder
$arr_teams = array();
$abf_teams = db_query("SELECT id, name, img FROM prefix_groups");
while ($row_teams = db_fetch_assoc($abf_teams)) {
    $team_member = array();
    $count_member = 0;
    $tid = $row_teams['id'];
    //Mitglieder
    $abf_mem = db_query("SELECT gu.uid, u.id as userid, u.name as username FROM prefix_groupusers as gu LEFT JOIN prefix_user as u on gu.uid = u.id WHERE gu.gid = ".$tid);
    while ($r_mem = db_fetch_assoc($abf_mem)) {
        $team_member[$r_mem['userid']] = $r_mem['username'];
        $count_member++;
    }
    $arr_teams[$tid]['name'] = $row_teams['name'];
    $arr_teams[$tid]['anz'] = $count_member;
    $arr_teams[$tid]['memb'] = $team_member;
    $arr_teams[$tid]['img'] = (empty($row_teams['img']) ? '' : $row_teams['img']);
}

$action = $menu->get(1);

//POST actionForm
if (isset($_POST['action_warning'])) {
    $wdtext = 'Es ist ein Fehler aufgetreten.';
    if (chk_antispam('adminuser_action', true) and isset($_POST['uid_warning'])) {
        $uid = escape($_POST['uid_warning'], 'integer');
        switch($_POST['action_warning']){
            
            //Status eines Users ndern
            case 'change_status_user':
                $name = get_n($uid);
                if ($uid != 1 and !empty($name)) {
                    $abf = db_query("SELECT status FROM prefix_user WHERE id = ".$uid);
                    while ($row = db_fetch_assoc($abf)) {
                        if ($row['status'] == 1) {
                            $status = 0;
                            $stat = 'inaktiv';
                        } else {
                            $status = 1;
                            $stat = 'aktiv';
                        }
                    }
                    if ($no_inactive_opt == 0 OR ($no_inactive_opt != 0 AND $status == 1)) {
                        $wdtext = 'Der Status des Users ' . $name . ' wurde auf ' . $stat . ' gesetzt.';
                    } elseif ($no_inactive_opt != 0 AND $status == 0) {
                        inactiveuser_del_from_userwarns($uid);
                        $wdtext = 'Der Status des Users ' . $name . ' wurde auf ' . $stat . ' gesetzt. Die Eintr&auml;ge aus der Warnliste wurden gel&ouml;scht';
                    }
                    inactiveuser_update_userstatus($uid, $status);
                }
            break;
            
            // einen User komplett lschen
            case 'delete_user':
                $name = get_n($uid);
                if ($uid != 1 and !empty($name)) {
                    user_remove($uid);
                    inactiveuser_del_from_userwarns($uid);
                    $wdtext = 'Der User ' . $name . ' wurde erfolgreich gel&ouml;scht.';
                }
            break;
            
            // Warncount eines User wieder auf null setzten
            case 'reset_user':
                $name = get_n($uid);
                if ($uid != 1 and !empty($name)) {
                    inactiveuser_del_from_userwarns($uid);
                    $wdtext = 'Die Warnungen des Users ' . $name . ' wurden erfolgreich zur&uuml;ck auf null gesetzt. Zyclus beginnt nun wieder von vorn.';
                }
            break;
            
            // Aways lschen
            case 'del_away':
                $name = get_n($uid);
                $id = escape($_POST['id_warning'], 'integer');
                inactiveuser_del_from_awaycal($id);
                $wdtext = 'Der Awaycall des Users ' . $name . ' wurde erfolgreich gel&ouml;scht.';
            break;
        
            // Aways zurcksetzen
            case 'reset_away':
            $name = get_n($uid);
            $id = escape($_POST['id_warning'], 'integer');
                    db_query("UPDATE prefix_awaycal SET pruef = 2 WHERE id = ".$id);
                    sendpm($_SESSION['authid'], $uid, 'Away-Anfrage', $lang['awaycalstatuschanged']);
                    $wdtext = 'Der Awaycall des Users ' . $name . ' wurde erfolgreich zur&uuml;ckgesetzt.';
            break;
        
            // einem User alle Rechte entziehen
            case 'change_user_rights':
                $name = get_n($uid);
                if ($uid != 1 and !empty($name)) {
                    inactiveuser_degrade_user($uid);
                    $wdtext = $name . ' wurde erfolgreich das Recht User gegeben, alle Modulrechte entzogen und aus den Teams gel&ouml;scht.';
                }
            break;
            
            // E-Mail an User
            case 'send_mail':
                $empf       = escape($_POST['empf'], 'string');
                $bet        = escape($_POST['bet'], 'string');
                $txt        = trim(escape($_POST['txt'], 'textarea'));
                $name       = get_n($uid);
                icmail($empf, $bet, $txt);
                $wdtext = 'Mail erfolgreich an '.$name.' verschickt';
            break;
        
            // Script manuell starten
            case 'run_script':
                inactiveuser_update_lastrun(0);
                require_once 'include/includes/func/inactiveuser.php';
                inactiveuser();
                $wdtext = 'Script erfolgreich manuell ausgelst';
            break;
        
            case 'set_user_immun':
                $komm = escape($_POST['id_warning'], 'string');
                $userid = array();
                $userid[0] = $uid;
                inactiveuser_set_immun($userid, 'user', $komm, '');
                $wdtext = 'User erfolgreich immun gesetzt und aus der Warn-Liste gelscht';
            break;
        }
    }
    if ($wdtext === false) {
        $antispam = get_antispam('adminuser_action', 0, true);
        ?><script type="text/javascript"><!--
            function updateParent() { parent.setNewAntispam(document.getElementById('tmp').childNodes[0]);}
                window.onload = function() { updateParent(); };
        //--></script>
        <div id="tmp"><?php echo $antispam; ?></div>
        <?php
        exit;
    }
    wd('admin.php?userwarns' . '#' . $action, $wdtext, 3);
    $design->footer(1);
}

//POST immunForm
if (isset($_POST['action_immun'])) {
    $wdtext = 'Es ist ein Fehler aufgetreten.';
    if (chk_antispam('adminuser_imunity', true) and isset($_POST['uid_immun'])) {
        $uid = escape($_POST['uid_immun'], 'integer');
        switch($_POST['action_immun']){
            
            //User immun setzen
            case 'set_user_immun':
                if (!isset($_POST['immun_user'])) {
                    $_POST['immun_user'] = '';
                }
                $wdtext = count($_POST['immun_user']).' User erfolgreich immun gesetzt';
                inactiveuser_set_immun($_POST['immun_user'], 'user', '', '');
            break;
        
            //User deimmunisieren
            case 'unset_user_immun':
                if (!isset($_POST['unimmun_user'])) {
                    $_POST['unimmun_user'] = '';
                }
                $wdtext = count($_POST['unimmun_user']).' User erfolgreich deimmunisiert';
                inactiveuser_unset_immun($_POST['unimmun_user'], 'user');
            break;
            
            //Grundrechte immun setzen
            case 'set_grecht_immun':
                if (!isset($_POST['immun_recht'])) {
                    $_POST['immun_recht'] = '';
                }
                $wdtext = 'Update immune Grundrechte-Gruppen erfolgreich';
                inactiveuser_set_grechte_immun ($_POST['immun_recht']);
            break;
            
            //Teams immun sezen
            case 'set_team_immun':
                if (!isset($_POST['immun_team'])) {
                    $_POST['immun_team'] = '';
                }
                $text = (count($_POST['immun_team']) == 1 ? 'Team' : 'Teams');
                $wdtext = count($_POST['immun_team']).' '.$text.' erfolgreich immun gesetzt';
                inactiveuser_set_immun($_POST['immun_team'], 'team', '', $arr_teams);
            break;
            
            //Team deimmunisieren
            case 'unset_team_immun':
                if (!isset($_POST['unimmun_team'])) {
                    $_POST['unimmun_team'] = '';
                }
                $text = (count($_POST['unimmun_team']) == 1 ? 'Team' : 'Teams');
                $wdtext = count($_POST['unimmun_team']).' '.$text.' erfolgreich deimmunisiert';
                inactiveuser_unset_immun($_POST['unimmun_team'], 'team');
            break;
        }
    }
    if ($wdtext === false) {
        $antispam = get_antispam('adminuser_imunity', 0, true);
        ?><script type="text/javascript"><!--
            function updateParent() { parent.setNewAntispam(document.getElementById('tmp').childNodes[0]);}
                window.onload = function() { updateParent(); };
        //--></script>
        <div id="tmp"><?php echo $antispam; ?></div>
        <?php
        exit;
    }
    wd('admin.php?userwarns' . '#' . $action, $wdtext, 3);
    $design->footer(1);
}

if (isset($_POST['opts_userwarn']) AND $_POST['opts_userwarn'] == 'yes') {
    $wdtext = 'Es ist ein Fehler aufgetreten.';
    if (chk_antispam('adminuser_options', true)) {
        $warn_active     = escape($_POST['warn_active'], 'integer');
        $nowarn_inactive = escape($_POST['nowarn_inactive'], 'integer');
        $warn_del        = escape($_POST['warn_del'], 'integer');
        $away_del        = escape($_POST['away_del'], 'integer');
        $warn_recht      = escape($_POST['warn_recht'], 'integer');
        $time_to_warn1   = escape($_POST['time_to_warn1'], 'integer');
        $time_to_warn2   = escape($_POST['time_to_warn2'], 'integer');
        $time_to_warn3   = escape($_POST['time_to_warn3'], 'integer');
        $mail_titel1     = escape($_POST['mail_titel1'], 'string');
        $mail_titel2     = escape($_POST['mail_titel2'], 'string');
        $mail_titel3     = escape($_POST['mail_titel3'], 'string');
        $mail_txt1       = escape($_POST['mail_txt1'], 'string');
        $mail_txt2       = escape($_POST['mail_txt2'], 'string');
        $mail_txt3       = escape($_POST['mail_txt3'], 'string');

        db_query("UPDATE prefix_user_warn_conf SET
            warn_active     = ".$warn_active.",
            nowarn_inactive = ".$nowarn_inactive.",
            warn_del        = ".$warn_del.",
            away_del        = ".$away_del.",
            warn_recht      = ".$warn_recht.",
            time_to_warn1   = ".$time_to_warn1.",
            time_to_warn2   = ".$time_to_warn2.",
            time_to_warn3   = ".$time_to_warn3.",
            mail_titel1     = '".$mail_titel1."',
            mail_titel2     = '".$mail_titel2."',
            mail_titel3     = '".$mail_titel3."',
            mail_txt1       = '".$mail_txt1."',
            mail_txt2       = '".$mail_txt2."',
            mail_txt3       = '".$mail_txt3."'");
        
        $wdtext = 'Settings gespeichert';
    }
    if ($wdtext === false) {
        $antispam = get_antispam('adminuser_options', 0, true);
        ?><script type="text/javascript"><!--
            function updateParent() { parent.setNewAntispam(document.getElementById('tmp').childNodes[0]);}
                window.onload = function() { updateParent(); };
        //--></script>
        <div id="tmp"><?php echo $antispam; ?></div>
        <?php
        exit;
    }
    wd('admin.php?userwarns' . '#' . $action, $wdtext, 1);
    $design->footer(1);
}

// Wenn lschen aktiviert, nicht bentigte Optionen ausblenden
$opt_del_recht = db_result(db_query("SELECT warn_del FROM prefix_user_warn_conf "));
if ($opt_del_recht != '0'){
    $classoptdel = 'style="height:30; display:none"';
} else {
    $classoptdel = 'style="height:30"';
}

// Wenn Liste User Warnungen leer 
if (db_num_rows(db_query("SELECT uid FROM prefix_user_warn")) != 0) {
    $classwarnlist = 'style="display:none"';
} else {
    $classwarnlist = '';
}

// Wenn Liste User Away leer 
if (db_num_rows(db_query("SELECT id FROM prefix_awaycal WHERE von <= NOW() AND bis >= NOW() AND pruef = 3")) != 0) {
    $classawaylist = 'style="display:none"';
} else {
    $classawaylist = '';
}

// Wenn Liste Inaktive User leer 
if (db_num_rows(db_query("SELECT id FROM prefix_user WHERE status = 0")) != 0) {
    $classinakt = 'style="display:none"';
} else {
    $classinakt = '';
}

//Wenn Liste immune User leer
if (0 == db_num_rows(db_query("SELECT id FROM prefix_user_warn_immun WHERE typ = 'user'"))) {
    $classimmunlist = '';
} else {
    $classimmunlist = 'style="display:none"';
}

//Wenn Liste immune Teams leer
if (0 == db_num_rows(db_query("SELECT id FROM prefix_user_warn_immun WHERE typ = 'team'"))) {
    $classimmun_teams = '';
} else {
    $classimmun_teams = 'style="display:none"';
}

$tpl->set('inaktlist', $classinakt);
$tpl->set('awaylist', $classawaylist);
$tpl->set('warnlist', $classwarnlist);      
$tpl->set('optdel', $classoptdel);
$tpl->set('immunlist', $classimmunlist);
$tpl->set('immunlist_teams', $classimmun_teams);

$qry = db_query("SELECT * FROM prefix_user_warn_conf");
while ($opts = db_fetch_object($qry)) {
    //Modul 'Inaktiv Warnungen' ein/aus
    if ($opts->warn_active == 1) {
        $warn_active1 = 'checked="checked"';
        $warn_active0 = '';
    } elseif ($opts->warn_active == 0) {
        $warn_active0 = 'checked="checked"';
        $warn_active1 = '';
    }
    
    //Inaktive User warnen ja/nein
    if ($opts->nowarn_inactive == 1) {
        $nowarn_inactive1 = 'checked="checked"';
        $nowarn_inactive0 = '';
    } elseif ($opts->nowarn_inactive == 0) {
        $nowarn_inactive0 = 'checked="checked"';
        $nowarn_inactive1 = '';
    }
    
    //User Lschen, Deaktiviern oder nur E-Mail senden
    if ($opts->warn_del == 1) {
        $warn_del1 = 'checked="checked"';
        $warn_del0 = '';
        $warn_del2 = '';
    } elseif ($opts->warn_del == 0) {
        $warn_del0 = 'checked="checked"';
        $warn_del1 = '';
        $warn_del2 = '';
    } elseif ($opts->warn_del == 2) {
        $warn_del2 = 'checked="checked"';
        $warn_del0 = '';
        $warn_del1 = '';
    }
    
    //Abgelaufene Aways lschen
    if ($opts->away_del == 1) {
        $away_del1 = 'checked="checked"';
        $away_del0 = '';
    } elseif ($opts->away_del == 0) {
        $away_del0 = 'checked="checked"';
        $away_del1 = '';
    }
    
    //User alle Rechte entziehen ja/nein
    if ($opts->warn_recht == 1) {
        $warn_recht1 = 'checked="checked"';
        $warn_recht0 = '';
    } elseif ($r->warn_recht == 0) {
        $warn_recht0 = 'checked="checked"';
        $warn_recht1 = '';
    }
    
    //Warn-Zeiten
    $time_to_warn1 = $opts->time_to_warn1;
    $time_to_warn2 = $opts->time_to_warn2;
    $time_to_warn3 = $opts->time_to_warn3;
    
    //Mail-Titel - Mail-Text - Absender
    $mail_titel1 = $opts->mail_titel1;
    $mail_titel2 = $opts->mail_titel2;
    $mail_titel3 = $opts->mail_titel3;
    $mail_txt1  = $opts->mail_txt1;
    $mail_txt2  = $opts->mail_txt2;
    $mail_txt3  = $opts->mail_txt3;
    
    //Datum Letzer Check
    if ($opts->lastrun == 0) {
        $lastrun = 'n/a';
    } else {
        $lastrun = date('d.m.Y | H:i:s',$opts->lastrun);
    }
    
    //Modul von Hand anstubsen wenn aktiv
    if ($opts->warn_active == 1) {
        $gobabygo = '<a href="javascript:void(0);" onclick="runscript();"><strong>Script manuell starten</strong></a>';
        $modulstatus = '<span style="color:#32CD32">Modul aktiviert</span>';
    } elseif ($opts->warn_active == 0) {
        $gobabygo = '';
        $modulstatus = '<span style="color:#FF0000">Modul deaktiviert</span>';
    }
}
    
$ar = array (
    'warn_active0'      => $warn_active0,
    'warn_active1'      => $warn_active1,
    'nowarn_inactive0'  => $nowarn_inactive0,
    'nowarn_inactive1'  => $nowarn_inactive1,
    'warn_del0'         => $warn_del0,
    'warn_del1'         => $warn_del1,
    'warn_del2'         => $warn_del2,
    'away_del0'         => $away_del0,
    'away_del1'         => $away_del1,
    'warn_recht0'       => $warn_recht0,
    'warn_recht1'       => $warn_recht1,
    'time_to_warn1'     => $time_to_warn1,
    'time_to_warn2'     => $time_to_warn2,
    'time_to_warn3'     => $time_to_warn3,
    'mail_titel1'       => $mail_titel1,
    'mail_titel2'       => $mail_titel2,
    'mail_titel3'       => $mail_titel3,
    'mail_txt1'         => $mail_txt1,
    'mail_txt2'         => $mail_txt2,
    'mail_txt3'         => $mail_txt3,
    'lastrun'           => $lastrun,
    'gobabygo'          => $gobabygo,
    'modulstatus'       => $modulstatus,
    'xajax'             => $xajax->getJavascript(),
    'action_antispam'   => get_antispam('adminuser_action', 0, true)
);
$tpl->set_ar_out($ar, 0);

//Ausgabe Warn-bersicht
$now = strtotime(date("Y-m-d"));
$class = '';
$wzahl = 0;    
$abf = db_query("SELECT w.uid, w.warn_count, w.warn_time, u.name as username, u.llogin as last_login, u.email, u.status, u.recht, g.id, g.name as rechtname
                FROM prefix_user_warn as w
                LEFT JOIN prefix_user as u on w.uid = u.id
                LEFT JOIN prefix_grundrechte as g on g.id = u.recht
                ORDER BY w.warn_count DESC");                
while ($row = db_fetch_assoc($abf)) {
    //check, ob User noch existiert
    if (get_n($row['uid'])) {
        //User nur dann in Warn-Tabelle einfgen, wenn sein Grundrecht nicht immun ist
        if (0 == db_num_rows(db_query("SELECT id FROM prefix_user_warn_immun WHERE immunid = ".$row['recht']." AND typ = 'user'"),0)) {
            $class = ($class == 'Cmite' ? 'Cnorm' : 'Cmite');

            //Icon fr aktiv/inaktiv
            if ($row['status'] == 1) {
                $status = 'jep';
                $titel = $row['username'].' ist Aktiv, jetzt deaktivieren?';
            } else {
                $status = 'nop';
                $titel = $row['username'].' ist Inaktiv, jetzt aktivieren?';
            }
            //Schriftfarbe abhngig von Anzahl Warnungen
            if ($row['warn_count'] == 2) {
                $fc = '#FF8C00';
            } elseif ($row['warn_count'] == 3) {
                $fc = '#FF0000';
            } else {
                $fc = '';
            }
            //Tage inaktiv
            $last_login = $row['last_login'];
            $diff = $now-$last_login;
            $diff = abs(ceil($diff/86400));
            $tage = ( $diff == 1 ? ' Tag' : ' Tage' );

            // User Rechte
            $rechtebez = $row['rechtname'];
            if ($row['rechtname'] == User) {
                $recht = $row['rechtname'];
            } else {
                $action = "'change_user_rights'";
                $af_id = "''";
                $recht = $row['rechtname'].' <a href="javascript:useraction_warning('.$action.', '.$af_id.', '.$row['uid'].')" title="'.$row['username'].' das Recht '.$row['rechtname'].' entziehen und alle Modulrechte l&ouml;schen?"><img src="include/images/icons/del.gif" border="0" alt="l&ouml;schen" /></a>';
            }

            $wzahl++;

            $arr = array (
                'class'         => $class,
                'wzahl'         => $wzahl,
                'uid'           => $row['uid'],
                'uname'         => $row['username'],
                'email'         => $row['email'],
                'status'        => $row['status'],
                'fc'            => $fc,
                'recht'         => $recht,
                'rechtbez'      => $rechtebez,
                'warncount'     => $row['warn_count'],
                'lastwarntime'  => date('d.m.Y' ,$row['warn_time']),
                'lastlogin'     => date('d.m.Y' ,$row['last_login']),
                'inactivesince' => $diff.$tage,
                'status'        => $status,
                'titel'         => $titel
            );  
            $tpl->set_ar_out($arr, 1);
        }
    } else {
        inactiveuser_del_from_userwarns($row['uid']);
    }
}
$tpl->out(2);


// User mit Aktiven und genehmigten Away abfragen
$class2 = '';
$azahl = 0;
$abf2 = db_query("SELECT a.id as awayid, a.uid, DATE_FORMAT(a.von,'%d.%m.%Y') as von, DATE_FORMAT(a.bis,'%d.%m.%Y') as bis, a.pruef, u.id, u.name, u.llogin, u.recht, u.email, g.id, g.name as rechtname 
                  FROM prefix_awaycal as a 
                  LEFT JOIN prefix_user as u on a.uid = u.id
                  LEFT JOIN prefix_grundrechte as g on g.id = u.recht
                  WHERE von <= NOW() AND bis >= NOW() AND pruef = 3");

while ($row2 = db_fetch_assoc($abf2)) {
    //check, ob User noch existiert
    if (get_n($row2['uid'])) {
        $id = $row2['uid'];
        $class2 = ($class2 == 'Cmite' ? 'Cnorm' : 'Cmite');

        //Tage bis Ende Away
        $bis = $row2['bis'];
        $bis = strtotime("$bis") ;
        $diff2 = $now - $bis;
        $daystoend = abs(ceil($diff2/86400));
        $tage2 = ( $diff2 == 1 ? ' Tag' : ' Tagen' );

        //Schriftfarbe verbleibende Tage Ende Away
        if ($daystoend <= 7) {
            $fcde = '#FF8C00';
        } elseif ($daystoend == 1) {
            $fcde = '#FF0000';
        } else {
            $fcde = '';
        }        

        $azahl++;       

        $arr2 = array(
            'class2'         => $class2,
            'azahl'          => $azahl,
            'awayid'         => $row2['awayid'],
            'uid2'           => $row2['uid'],
            'uname2'         => $row2['name'],
            'email2'         => $row2['email'],
            'awayvon'        => $row2['von'],
            'awaybis'        => $row2['bis'],
            'fcde'           => $fcde,
            'daystoend'      => $daystoend.$tage2,
            'lastlogin2'     => date('d.m.Y' ,$row2['llogin']),
            'recht2'         => $row2['rechtname']
        );
        $tpl->set_ar_out($arr2, 3);
        $tpl->out(4);
    } else {
        inactiveuser_del_from_awaycal($row2['awayid']);
    }
}

// Liste der User die sich selbst als inaktiv markiert haben ein und ausblenden
if (0 == db_result(db_query("SELECT nowarn_inactive FROM prefix_user_warn_conf "))) {
    $classinact = 'style="display:none"';
} else {
    $classinact = '';
}
$tpl->set('inactlist', $classinact);   
$tpl->out(5);

// User abfragen die sich selbst als inaktiv markiert haben und somit keine Warnungen erhalten
$class3 = '';
$izahl = 0;
$abf3 = db_query("SELECT u.id as uid, u.name, u.llogin, u.email, u.status, u.recht, g.id, g.name as rechtname 
                  FROM prefix_user as u 
                  LEFT JOIN prefix_grundrechte as g on g.id = u.recht
                  WHERE status = 0");

while ($row3 = db_fetch_assoc($abf3)) {
    $id = $row3['uid'];
    if ( 0 == db_result(db_query("SELECT COUNT(*) FROM prefix_user_warn WHERE uid = ".$id),0)) {
        $class3 = ($class3 == 'Cmite' ? 'Cnorm' : 'Cmite');
        
        //Tage inaktiv
        $last_login3 = $row3['llogin'];
        $diff3 = $now-$last_login3;
        $diff3 = abs(ceil($diff3/86400));
        $tage3 = ( $diff3 == 1 ? ' Tag' : ' Tage' );
        
        //Icon fr aktiv/inaktiv
        if ($row3['status'] == 1) {
            $status3 = 'jep';
            $titel3 = $row3['name'].' ist Aktiv, jetzt deaktivieren?';
        } else {
            $status3 = 'nop';
            $titel3 = $row3['name'].' ist Inaktiv, jetzt aktivieren?';
        }
       
        // User Rechte
        if ($row3['rechtname'] == User) {
            $recht3 = $row3['rechtname'];
        } else {
            $action = "'change_user_rights'";
            $af_id = "''";
            $recht3 = $row3['rechtname'].' <a href="javascript:useraction_warning('.$action.', '.$af_id.', '.$row3['uid'].')" title="Das Recht '.$row3['rechtname'].' entziehen und alle eventuellen Modulrechte l&ouml;schen?"><img src="include/images/icons/del.gif" border="0" alt="l&ouml;schen" /></a>';
        }
        
        $izahl++;
        
        $arr3 = array(
            'class3'         => $class3,
            'izahl'          => $izahl,
            'uid3'           => $row3['uid'],
            'uname3'         => $row3['name'],
            'email3'         => $row3['email'],
            'status3'        => $status3,
            'titel3'         => $titel3,
            'recht3'         => $recht3,
            'lastlogin3'     => date('d.m.Y' ,$row3['llogin']),
            'inactivesince3' => $diff3.$tage3
        );
        $tpl->set_ar_out($arr3, 6);
    }
    $tpl->out(7);
}
$tpl->out(8);

// Immune Grundrechte
$abf_immun_gr = db_query("SELECT * FROM prefix_user_warn_immun WHERE typ = 'grundrecht'");
$immun_grecht_ids = array();
while ($row_immun_gr = db_fetch_assoc($abf_immun_gr)) {
    $immun_grecht_id = $row_immun_gr['immunid'];
    $immun_grecht_ids[$immun_grecht_id][] = $row_immun_gr;
}

$grquery = db_query("SELECT id, name FROM prefix_grundrechte WHERE id<0 ORDER BY id ASC");
$arr_grechte_cb = array();

while ($r = db_fetch_object($grquery)) {
    $status = array_key_exists($r->id, $immun_grecht_ids) ? 'immun' : 'affected';
    $action = array_key_exists($r->id, $immun_grecht_ids) ? 'unset' : 'set';
    $grechtname = $r->name;
    if ($status == 'immun') {
        $titelo = $alto = 'Grundrecht immun - Klicken zum Deimmunisieren';
        $titelu = $altu = 'Grundrecht nicht immun - Klicken zum Immunisieren';
        $grechtimgo = '<img class="grechtimg" id="grechtimgo'.$r->id.'" src="include/images/icons/admin/immun.png" width="20" border="0" title="'.$titelo.'" alt="'.$alto.'" onclick="grecht_immun_change('.$r->id.');" />';
        $grechtimgu = '<img class="grechtimg" id="grechtimgu'.$r->id.'" src="include/images/icons/admin/affected.png" width="20" border="0" title="'.$titelu.'" alt="'.$altu.'" style="display: none" onclick="grecht_immun_change('.$r->id.');" />';
    } else {
        $titelo = $alto = 'Grundrecht nicht immun - Klicken zum Immunisieren';
        $titelu = $altu = 'Grundrecht immun - Klicken zum Deimmunisieren';
        $grechtimgo = '<img class="grechtimg" id="grechtimgo'.$r->id.'" src="include/images/icons/admin/affected.png" width="20" border="0" title="'.$titelo.'" alt="'.$alto.'" onclick="grecht_immun_change('.$r->id.');" />';
        $grechtimgu = '<img class="grechtimg" id="grechtimgu'.$r->id.'" src="include/images/icons/admin/immun.png" width="20" border="0" title="'.$titelu.'" alt="'.$altu.'" style="display: none" onclick="grecht_immun_change('.$r->id.');" />';
    }
    
    $arr_grechte = array(
        'grechtname'    => $grechtname,
        'grechtimgu'    => $grechtimgu,
        'grechtimgo'    => $grechtimgo
    );
    $tpl->set_ar_out($arr_grechte, 9);
    $arr_grechte_cb[$r->id] = $r->name;
}
$tpl->out(10);

//Popup Teams Immun
$count_teams = 0;
$class_teams_search = '';
foreach ($arr_teams as $teamid=>$teamval) {
    //$tid = $key;
    if (0 == db_num_rows(db_query("SELECT id FROM prefix_user_warn_immun WHERE immunid = ".$teamid." AND typ = 'team'"))) {
        $class_teams_search = ($class_teams_search == 'trCmite-immun-teams' ? 'trCnorm-immun-teams' : 'trCmite-immun-teams');
        $tnamecb = '<input type="checkbox" value="'.$teamid.'" class="immunteam-cb" name="immun_team[]" id="immun_team_'.$teamid.'">';
        
        $arr_unimmun_teams = array(
            'class'         => $class_teams_search,
            'tid'           => $teamid,
            'tname'         => $arr_teams[$teamid]['name'],
            'tanz'          => $arr_teams[$teamid]['anz'],
            'tnamecb'       => $tnamecb,
            'tmembernames'  => implode(', ', $teamval['memb']),
            'count'         => $count_teams
        );
        $tpl->set_ar_out($arr_unimmun_teams, 11);
        $count_teams++;
    }
}
$tpl->out(12);

//Popup User Immun
$abf_unimmun_user = db_query("SELECT u.id, u.recht, u.name, gr.id as grechtid, gr.name as rechtename 
                              FROM prefix_user as u
                              LEFT JOIN prefix_grundrechte as gr on u.recht = gr.id
                              WHERE u.id NOT IN (SELECT uwi.immunid FROM prefix_user_warn_immun uwi WHERE uwi.immunid>0 AND uwi.typ='user')");
$count = 0;
$class_user_search = '';
while ($unimmmun_user = db_fetch_assoc($abf_unimmun_user)) {
    $class_user_search = ($class_user_search == 'trCmite-immun-user' ? 'trCnorm-immun-user' : 'trCmite-immun-user');
    $unamecb = '<input type="checkbox" value="'.$unimmmun_user['id'].'" class="immunuser-cb" name="immun_user[]" id="immun_user_'.$unimmmun_user['id'].'">';
    $arr_unimmun_user = array(
        'class'     => $class_user_search,
        'uid'       => $unimmmun_user['id'],
        'uname'     => $unimmmun_user['name'],
        'urecht'    => $unimmmun_user['rechtename'],
        'unamecb'   => $unamecb,
        'count'     => $count
    );
    $tpl->set_ar_out($arr_unimmun_user, 13);
    $count++;
}
$tpl->set_out('imunity_antispam', get_antispam('adminuser_imunity', 0, true), 14);

//immune Teams
$class_t = '';
foreach ($arr_teams as $tid=>$team) {
    if (1 == db_num_rows(db_query("SELECT COUNT(*) FROM prefix_user_warn_immun WHERE immunid = ".$tid." AND typ = 'team'"),0)) {
        $abf_unimmun_teams = db_query("SELECT * FROM prefix_user_warn_immun WHERE immunid = ".$tid." AND typ = 'team'");
        while ($unimmmun_teams = db_fetch_assoc($abf_unimmun_teams)) {
            $class_t = ($class_t == 'Cmite' ? 'Cnorm' : 'Cmite');
            $tnamecb = '<input type="checkbox" value="'.$tid.'" class="unimmun-team" name="unimmun_team[]" id="unimmun_team_'.$tid.'">';
            $team_immuntime = date ('d.m.Y', $unimmmun_teams['time']);
            $team_komm = $unimmmun_teams['komm'];
            $team_immunsetter = $unimmmun_teams['adname'];

            $arr = array(
                'class'         => $class_t,
                'tid'           => $tid,
                'unimmunteamcb' => $tnamecb,
                'tname'         => $arr_teams[$tid]['name'],
                'tmembernames'  => implode(', ', $team['memb']),
                'tmemberanz'    => $arr_teams[$tid]['anz'],
                'immuntime'     => $team_immuntime,
                'setter'        => $team_immunsetter,
                'tkomm'         => $team_komm
            );
            $tpl->set_ar_out($arr, 15);
        }
    }
}
$tpl->out(16);

//Immun-Liste
$immun_grechte = array();
$abf_grechte_immun = db_query("SELECT uwi.immunid, gr.id, gr.name
                               FROM prefix_user_warn_immun as uwi
                               LEFT JOIN prefix_grundrechte as gr on uwi.immunid = gr.id
                               WHERE immunid<0 AND typ='grundrecht'");
while ($immun_grecht = db_fetch_assoc($abf_grechte_immun)) {
    $immun_grecht_name = $immun_grecht['name'];
    $immun_grechte[$immun_grecht_name][] = $immun_grecht['id'];
}

$sel = db_query("SELECT i.id, i.immunid, i.typ, i.adname, i.komm, i.time, u.id as userid, u.name as username, u.recht, gr.name as rechtename
                FROM prefix_user_warn_immun as i
                LEFT JOIN prefix_user as u ON i.immunid = u.id
                LEFT JOIN prefix_grundrechte as gr ON u.recht = gr.id
                WHERE i.immunid>0 AND i.typ='user' ORDER BY username ASC");

$immunTeamMembers = array();
foreach ($arr_teams as $tid => $team) {
    if (db_result(db_query("SELECT COUNT(*) FROM prefix_user_warn_immun WHERE immunid = ".$tid." AND typ = 'team'")) > 0) {
        foreach ($team['memb'] as $userId => $userName) {
            $immunTeamMembers[$userId][] = $team['name'];
        }
    }
}

$class_il = '';
while ($immun_user = db_fetch_assoc($sel)) {
    //check, ob User noch existiert
    if (get_n($immun_user['immunid'])) {
        //check, ob das grundrecht des users bereits immun - Icon sichtbar
        $immun_icon_grecht = '';
        if (array_key_exists($immun_user['rechtename'], $immun_grechte)) {
            $immun_icon_grecht = '<img class="grechtimg" id="twice-immun-icon-'.$immun_user['immunid'].'" src="include/images/icons/admin/immun_grights.png" width="20" border="0" title="Ebenfalls per Grundrecht '.$immun_user['rechtename'].' immun" alt="Ebenfalls per Grundrecht '.$immun_user['rechtename'].' immun" style="float: right" />';
        }
        
        //check, ob User in immunem Team - Icon sichtbar
        $immun_icon_team = '';
        if (isset($immunTeamMembers[$immun_user['userid']])) {
            $title = 'Ebenfalls durch Team ' . implode(',  ',$immunTeamMembers[$immun_user['userid']] ) . ' immun';
            $immun_icon_team = '<img class="teamimg" id="tripple-immun-icon-' . $immun_user['immunid']
                . '" src="include/images/icons/admin/immun_teams.png" width="20" border="0" title="' . $title . '" alt="'
                . $title . '" style="float: right" />';
        }
        
        $unimmun_user_cb = '<input type="checkbox" id="unimmun_user_'.$immun_user['userid'].'" class="unimmun-user" value="'.$immun_user['userid'].'" name="unimmun_user[]">';

        $class_il = ($class_il == 'Cmite' ? 'Cnorm' : 'Cmite');
        $immuntime = date ('d.m.Y', $immun_user['time'] );
        
        if(empty($immun_user['komm'])) {
        $immunkom = 'n/a';
        } else {
        $immunkom = $immun_user['komm'];
        }
        
        $arr_user = array(
            'CLASS'                 => $class_il,
            'UID'                   => $immun_user['userid'],
            'unimmunusercb'         => $unimmun_user_cb,
            'NAME'                  => $immun_user['username'],
            'STATUS_IMMUN_GRECHT'   => $immun_icon_grecht,
            'STATUS_IMMUN_TEAM'     => $immun_icon_team,
            'RECHT'                 => $immun_user['rechtename'],
            'SETTER'                => $immun_user['adname'],
            'IMMUNTIME'             => $immuntime,
            'KOMM'                  => $immunkom
        );
        $tpl->set_ar_out($arr_user, 17);
    } else {
        inactiveuser_del_from_userwarns($immun_user['immunid']);
    }
}
$tpl->set('options_antispam', get_antispam('adminuser_options', 0, true));
$tpl->out(18);

$design->footer();
?>
