<?php

########################################################
#                                                      #
#   Inactive User Manager  v2.3  Funktionen            #
#    2014 by Outi77 & LordOfDeath                     #
#     Code Anpassung & Optimierung: Mairu              #
#   ------------------------------------------------   #
#   Support: www.ilch.de                               #
#   ------------------------------------------------   #
#   Homepage: Outi77       (www.sivos.de)              #
#             LordOfDeath  (www.altehasen-gaming.de)   #
#             Mairu        (www.mairu.ilch.de)         #
#                                                      #
########################################################

defined ('main') or die ( 'no direct access' );

// Platzhalter in eMails ersetzen und senden
function inactiveuser_getMailTemplates($type, $row, $conf, $diff)
{
    $search = array('#NAME#', '#TAGE#', '#LAST#', '#NEXT1#', '#NEXT2#');
    $replace = array($row['name'], $diff, date('d.m.Y' ,$row['last_login']), $conf['time_to_warn2'], $conf['time_to_warn3']);
    $mailtitle = str_replace($search, $replace, $conf['mail_titel' . $type]);
    $mailtext = str_replace($search, $replace, $conf['mail_txt' . $type]);
    return array($mailtitle, $mailtext);
}

//User degradieren
function inactiveuser_degrade_user($uid) {
    db_query("UPDATE prefix_user SET recht = -1, spezrank = 0 WHERE id = ".$uid);
    db_query("DELETE FROM prefix_modulerights WHERE uid = ".$uid);
    db_query("DELETE FROM prefix_groupusers WHERE uid = ".$uid);
    db_query("DELETE FROM prefix_forummods WHERE uid = ".$uid);
}

//User aus warn-Tabelle lschen
function inactiveuser_del_from_userwarns($uid) {
    db_query("DELETE FROM prefix_user_warn WHERE uid = ".$uid);
}

//Lschen aus awaycal
function inactiveuser_del_from_awaycal($id) {
    db_query("DELETE FROM prefix_awaycal WHERE `id` = ".$id);
}

//Update User in warn-Tabelle
function inactiveuser_update_user_warn($uid, $warncount, $warntime) {
    db_query("UPDATE prefix_user_warn SET warn_count = $warncount,warn_time = $warntime WHERE uid = ".$uid);
}

//Update Userstatus
function inactiveuser_update_userstatus($uid, $status) {
    db_query("UPDATE prefix_user SET status = $status WHERE id = ".$uid);
}

//Immun-Liste - User oder Teams immun setzen
function inactiveuser_set_immun ($immunall, $typ, $komm, $team_arr) {
    if (!empty($immunall)) {
        foreach ($immunall as $immunone) {
            switch ($typ) {
                case 'user':
                    if (isset($_POST['immunuser-komm-'.$immunone]) && !empty($_POST['immunuser-komm-'.$immunone])) {
                        $komm = escape($_POST['immunuser-komm-'.$immunone], 'string');
                    } elseif ($komm == '') {
                        $komm = 'User';
                    }
                    inactiveuser_del_from_userwarns($immunone);
                break;
                case 'team';
                    if (isset($_POST['immunteams-komm-'.$immunone]) && !empty($_POST['immunteams-komm-'.$immunone])) {
                        $komm = escape($_POST['immunteams-komm-'.$immunone], 'string');
                    } elseif ($komm == '') {
                        $komm = 'Team';
                    }
                    //jeden user im team aus warnliste entfernen
                    foreach ($team_arr as $tid=>$team) {
                        if ($tid == $immunone) {
                            $names = implode(', ', $team['memb']);
                            foreach ($team['memb'] as $memberid=>$membername) {
                                inactiveuser_del_from_userwarns($memberid);
                            }
                        }
                    }
                break;
            }
            db_query("INSERT INTO prefix_user_warn_immun (immunid, typ, adname, komm, time) VALUES (".$immunone.",'".$typ."','".$_SESSION['authname']."','".$komm."',".time().")");
        }
    }
}

//Immun-Liste - User oder Teams deimmunisieren
function inactiveuser_unset_immun ($unimmunall, $typ) {
    if (!empty($unimmunall)) {
        foreach ($unimmunall as $unimmunone) {
            db_query("DELETE FROM prefix_user_warn_immun WHERE immunid = ".$unimmunone." AND typ = '".$typ."'");
        }
    }
}

//check, ob User in immunem Team
function inactiveuser_del_immun_teamusers_from_warnlist() {
    // zuerst die verwarnten User ermitteln
    $warned_user_arr = array();
    $abf_warned_user = db_query("SELECT * FROM prefix_user_warn");
    while ($row_warned_user = db_fetch_assoc($abf_warned_user)) {
        $warned_user_arr[$row_warned_user['uid']] = $row_warned_user['uid'];
    }

    // immune Teams ermitteln
    $immun_teams_ar = array();
    $abf_immun_teams = db_query("SELECT immunid FROM prefix_user_warn_immun WHERE typ = 'team'");
    while ($row_immun_teams = db_fetch_assoc($abf_immun_teams)) {
        $immun_teams_ar[$row_immun_teams['immunid']] = $row_immun_teams['immunid'];
    }

    // User-Array durchlaufen und Team-ID's suchen - wenn gefunden, dann aus Warnliste lschen
    foreach ($warned_user_arr as $uid) {
        $abf_user_pro_team = db_query('SELECT * FROM prefix_groupusers WHERE gid IN (' . implode(', ', array_keys($immun_teams_ar)) . ') AND uid = ' . $uid);
        if (db_num_rows($abf_user_pro_team) > 0) {
            inactiveuser_del_from_userwarns($uid);
        }
    }
}

//Update lastrun timestamp
function inactiveuser_update_lastrun ($timestamp) {
    db_query("UPDATE prefix_user_warn_conf SET lastrun = '".$timestamp."'");
}