DROP TABLE prefix_online;
CREATE TABLE `prefix_online` (
  `uptime` datetime default NULL,
  `sid` varchar(32) NOT NULL default '',
  `ipa` varchar(15) NOT NULL default '',
  `uid` mediumint(9) NOT NULL default '0'
) TYPE=MyISAM COMMENT='powered by ilch.de';

ALTER TABLE `prefix_userfuncs` RENAME `prefix_groupfuncs`;

UPDATE prefix_allg SET v2 = 'news' WHERE k = 'ALLG' AND v1 = 'smodul';

CREATE TABLE `prefix_config` (
  `schl` varchar(50) NOT NULL default '',
  `typ` varchar(10) NOT NULL default '',
  `kat` varchar(50) NOT NULL default '',
  `frage` varchar(255) NOT NULL default '',
  `wert` text NOT NULL,
  PRIMARY KEY  (`schl`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

INSERT  INTO prefix_config (schl , typ, kat, frage, wert ) 
SELECT v1, v3, v4, t1, v2 FROM prefix_allg WHERE k =  'ALLG';

UPDATE prefix_config SET typ = 'input' WHERE typ = 't';

DELETE FROM prefix_allg WHERE k = 'ALLG';

INSERT INTO `prefix_config` VALUES ('archiv_down_userupload', 'r2', 'Archiv Optionen', 'D&uuml;rfen User Dateien hochladen?', '1');
INSERT INTO `prefix_config` VALUES ('show_session_id', 'r2', 'Allgemeine Optionen', 'SessionID bei G&auml;sten anzeigen?', '1');
INSERT INTO `prefix_config` VALUES ('wars_last_komms', 's', 'Wars Optionen', 'Kommentare fr Lastwars', '0');
INSERT INTO `prefix_config` VALUES ('wars_last_limit', 'input', 'Wars Optionen', 'Lastwars pro Seite.', '15');
INSERT INTO `prefix_config` VALUES ('forum_usergallery', 'r2', 'Forum Optionen', 'Darf jeder User seine eigene Gallery haben?', '1');
INSERT INTO `prefix_config` VALUES ('gallery_normal_width', 'input', 'Gallery Optionen', 'Breite der normalen Bilder', '500');
INSERT INTO `prefix_config` VALUES ('gallery_img_koms', 'r2', 'Gallery Optionen', 'Kommentare fr Bilder zulassen?', '1');
INSERT INTO `prefix_config` VALUES ('forum_max_sig', 'input', 'Forum Optionen', 'max. Anzahl Zeichen in der Signatur', '200');
INSERT INTO `prefix_config` VALUES ('gbook_koms_for_inserts', 'r2', 'G&auml;stebuch Optionen', 'Kommentare f&uuml;r G&auml;stebucheintr&auml;ge?', '1');
INSERT INTO `prefix_config` VALUES ('allg_regeln', 'textarea', 'Allgemeine Optionen', 'Die Regeln fr die Seite (bbcode erlaubt)', '[list]\r\n[*]Die Registrierung ist vllig Kostenlos\r\n[*]Die Betreiber der Seite bernehmen keine Haftung.\r\n[*]Bitte verhalten Sie sich angemessen und mit Respekt gegenber den anderen Community Mitgliedern.\r\n[/list]');
INSERT INTO `prefix_config` VALUES ('teams_show_list', 'r2', 'Team Optionen', 'Avatar bei den Usern?', '0');
INSERT INTO `prefix_config` VALUES ('teams_show_cat', 'r2', 'Team Optionen', 'Sollen die Squads als Kategorie angezeigt werden?', '1');

ALTER TABLE `prefix_menu` CHANGE `link` `path` VARCHAR( 100 ) NOT NULL ;

ALTER TABLE `prefix_menu` DROP `id` , DROP `sub` ;

ALTER TABLE `prefix_menu` ADD PRIMARY KEY ( `pos` , `wo` );

update prefix_menu set was = 17 where was = 3;
update prefix_menu set was = 3 where was = 2;
UPDATE prefix_menu SET path =  REPLACE ( path, '?m=', '' );



INSERT INTO `prefix_allg` VALUES ('', 'kasse_kontodaten', '', '', '', '', '', '', 'Kontoinhaber: Max Mustermann\r\nBankname: Muster Sparkasse\r\nKontonummer: 123\r\nBankleitzahl: 123\r\nBIC: 123\r\nIBAN: 123\r\nVerwendungszweck: Spende fr ilch.de ;-)');
INSERT INTO `prefix_allg` VALUES ('', 'picofx', 'pic', '0', '', '', '', '', '');
INSERT INTO `prefix_allg` VALUES ('', 'picofx', 'directory', '0', '', '', '', '', '');
INSERT INTO `prefix_allg` VALUES ('', 'picofx', 'interval', '0', '', '', '', '', '');
INSERT INTO `prefix_allg` VALUES ('', 'picofx', 'nextchange', '0', '', '', '', '', '');
INSERT INTO `prefix_allg` VALUES ('', 'picofx', 'picwidth', '100', '', '', '', '', '');
INSERT INTO `prefix_allg` VALUES ('', 'trainzeiten', '', '', '', '', '', '', 'Kein Train#Kein Train#Kein Train#Kein Train#Kein Train#Kein Train#Kein Train');

ALTER TABLE `prefix_koms` ADD `cat` VARCHAR( 10 ) NOT NULL AFTER `uid` ;
UPDATE prefix_koms SET cat = SUBSTRING( uid, 1, 4 ) WHERE SUBSTRING( uid, 1, 5  )  = 'NEWS_';
UPDATE prefix_koms SET uid = SUBSTRING( uid, 6 ) WHERE SUBSTRING( uid, 1, 5  )  = 'NEWS_';

ALTER TABLE `prefix_koms` CHANGE `uid` `uid` MEDIUMINT NOT NULL;

ALTER TABLE `prefix_smilies` ADD `emo` VARCHAR( 75 ) NOT NULL AFTER `ent` ;
ALTER TABLE `prefix_smilies` CHANGE `url` `url` VARCHAR( 100 ) NOT NULL ;
UPDATE prefix_smilies SET emo = ent, url = REPLACE(url, 'include/images/smiles/', '');

ALTER TABLE `prefix_pm` ADD `status` TINYINT( 1 ) NOT NULL AFTER `gelesen` ;

CREATE TABLE `prefix_forummods` (
  `uid` mediumint(9) NOT NULL default '0',
  `fid` mediumint(9) NOT NULL default '0',
  PRIMARY KEY  (`uid`,`fid`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

ALTER TABLE `prefix_forums` DROP `mods` ;

ALTER TABLE `prefix_user`
ADD `spezrank` MEDIUMINT NOT NULL ,
ADD `opt_pm` TINYINT( 1 ) NOT NULL ,
ADD `opt_pm_popup` TINYINT( 1 ) NOT NULL ,
ADD `opt_mail` TINYINT( 1 ) NOT NULL ,
ADD `status` TINYINT( 1 ) NOT NULL ,
ADD `geschlecht` TINYINT( 1 ) NOT NULL ,
ADD `gebdatum` DATE NOT NULL ,
ADD `wohnort` VARCHAR( 30 ) NOT NULL ,
ADD `homepage` VARCHAR( 30 ) NOT NULL ,
ADD `staat` VARCHAR( 30 ) NOT NULL ,
ADD `avatar` VARCHAR( 50 ) NOT NULL ,
ADD `icq` VARCHAR( 20 ) NOT NULL ,
ADD `msn` VARCHAR( 30 ) NOT NULL ,
ADD `yahoo` VARCHAR( 30 ) NOT NULL ,
ADD `aim` VARCHAR( 30 ) NOT NULL ,
ADD `sig` TEXT NOT NULL ;


CREATE TABLE `prefix_usergallery` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `uid` mediumint(9) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `endung` varchar(5) NOT NULL default '',
  `besch` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_topic_alerts` (
  `tid` mediumint(9) NOT NULL default '0',
  `uid` mediumint(9) NOT NULL default '0',
  PRIMARY KEY  (`tid`,`uid`)
) TYPE=MyISAM;

CREATE TABLE `prefix_gallery_cats` (
  `id` mediumint(9) NOT NULL auto_increment,
  `cat` mediumint(9) NOT NULL default '0',
  `pos` smallint(6) NOT NULL default '0',
  `recht` smallint(6) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `besch` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

CREATE TABLE `prefix_gallery_imgs` (
  `id` int(11) NOT NULL auto_increment,
  `cat` mediumint(9) NOT NULL default '0',
  `klicks` mediumint(9) NOT NULL default '0',
  `vote_wertung` float NOT NULL default '0',
  `vote_klicks` mediumint(9) NOT NULL default '0',
  `datei_name` varchar(50) NOT NULL default '',
  `endung` varchar(5) NOT NULL default '',
  `besch` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';


CREATE TABLE `prefix_grundrechte` (
  `id` smallint(6) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

INSERT INTO `prefix_grundrechte` VALUES (0, 'Gast');
INSERT INTO `prefix_grundrechte` VALUES (-1, 'User');
INSERT INTO `prefix_grundrechte` VALUES (-2, 'Superuser');
INSERT INTO `prefix_grundrechte` VALUES (-3, 'Trialmember');
INSERT INTO `prefix_grundrechte` VALUES (-4, 'Member');
INSERT INTO `prefix_grundrechte` VALUES (-5, 'CoLeader');
INSERT INTO `prefix_grundrechte` VALUES (-6, 'Leader');
INSERT INTO `prefix_grundrechte` VALUES (-7, 'SiteAdmin');
INSERT INTO `prefix_grundrechte` VALUES (-8, 'CoAdmin');
INSERT INTO `prefix_grundrechte` VALUES (-9, 'Admin');

CREATE TABLE `prefix_kalender` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `time` int(11) NOT NULL default '0',
  `title` varchar(100) NOT NULL default '',
  `text` text NOT NULL,
  `recht` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';


CREATE TABLE `prefix_kasse` (
  `id` int(14) NOT NULL auto_increment,
  `datum` date NOT NULL default '0000-00-00',
  `name` varchar(50) NOT NULL,
  `verwendung` varchar(50) NOT NULL,
  `betrag` float NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='powered by ilch.de';

ALTER TABLE `prefix_groups`
ADD `mod1` MEDIUMINT NOT NULL ,
ADD `mod2` MEDIUMINT NOT NULL,
ADD `mod3` MEDIUMINT NOT NULL,
ADD `mod4` MEDIUMINT NOT NULL,
ADD `pos` SMALLINT NOT NULL ,
ADD `zeigen` TINYINT( 1 ) NOT NULL ,
ADD `show_fightus` TINYINT( 1 ) NOT NULL ,
ADD `show_joinus` TINYINT( 1 ) NOT NULL ,
ADD `img` VARCHAR( 50 ) NOT NULL ;

UPDATE prefix_groups, prefix_teams
SET
prefix_groups.img = prefix_teams.img,
prefix_groups.pos = prefix_teams.pos,
prefix_groups.mod1 = prefix_teams.`mod`,
prefix_groups.zeigen =1,
prefix_groups.show_fightus =1,
prefix_groups.show_joinus =1
WHERE prefix_teams.gid = prefix_groups.id;

DROP TABLE `prefix_teams` ;

ALTER TABLE `prefix_awards` CHANGE `time` `time` DATE NOT NULL  ;
ALTER TABLE `prefix_awards` ADD `bild` VARCHAR( 100 ) NOT NULL AFTER `wofur` ;
ALTER TABLE `prefix_downcats` ADD `recht` TINYINT NOT NULL AFTER `pos` ;
ALTER TABLE `prefix_downloads` ADD `ssurl` VARCHAR( 100 ) NOT NULL AFTER `surl` ;
ALTER TABLE `prefix_downloads` ADD `vote_klicks` INT NOT NULL AFTER `downs` ,
ADD `vote_wertung` FLOAT NOT NULL AFTER `vote_klicks` ;

delete from prefix_modules where module = 'forumsite';
delete from prefix_modules where module = 'teams';

ALTER TABLE `prefix_modules` ADD `url` VARCHAR( 20 ) NOT NULL AFTER `module` ,
ADD `name` VARCHAR( 50 ) NOT NULL AFTER `url` ;
 
update prefix_modules set name = module, url = module;

ALTER TABLE `prefix_modules` CHANGE `module` `id` MEDIUMINT NOT NULL AUTO_INCREMENT;

INSERT INTO `prefix_modules` VALUES ('', 'archiv-downloads', 'Downloads', 1, 0, 1);
INSERT INTO `prefix_modules` VALUES ('', 'kalender', 'Kalender', 1, 0, 1);
INSERT INTO `prefix_modules` VALUES ('', 'kasse', 'Kasse', 1, 0, 1);
INSERT INTO `prefix_modules` VALUES ('', 'gbook', 'Gbook', 1, 0, 1);
INSERT INTO `prefix_modules` VALUES ('', 'awaycal', 'Awaycal', 0, 0, 1);

TRUNCATE TABLE `prefix_modulerights` ;

ALTER TABLE `prefix_modulerights` CHANGE `module` `mid` MEDIUMINT NOT NULL ;
ALTER TABLE `prefix_modulerights` CHANGE `uogid` `uid` MEDIUMINT DEFAULT '0' NOT NULL ;

update prefix_user set recht = -9 WHERE recht = -5;
update prefix_user set recht = -6 WHERE recht = -4;
update prefix_user set recht = -4 WHERE recht = -3;
update prefix_user set recht = -3 WHERE recht = -2;

update prefix_menu set recht = -9 WHERE recht = -5;
update prefix_menu set recht = -6 WHERE recht = -4;
update prefix_menu set recht = -4 WHERE recht = -3;
update prefix_menu set recht = -3 WHERE recht = -2;

update prefix_news set news_recht = -9 WHERE news_recht = -5;
update prefix_news set news_recht = -6 WHERE news_recht = -4;
update prefix_news set news_recht = -4 WHERE news_recht = -3;
update prefix_news set news_recht = -3 WHERE news_recht = -2;

update prefix_forums set view = -9 WHERE view > 0;
update prefix_forums set reply = -9 WHERE reply > 0;
update prefix_forums set start = -9 WHERE start > 0;

update prefix_user, prefix_userfields
SET prefix_user.wohnort = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 1;
DELETE FROM prefix_userfields WHERE fid = 1;

update prefix_user, prefix_userfields
SET prefix_user.opt_pm = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 2;
DELETE FROM prefix_userfields WHERE fid = 2;
  
update prefix_user, prefix_userfields
SET prefix_user.opt_mail = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 3;
DELETE FROM prefix_userfields WHERE fid = 3;
  
update prefix_user, prefix_userfields
SET prefix_user.homepage = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 4;
DELETE FROM prefix_userfields WHERE fid = 4;
  
 update prefix_user, prefix_userfields
SET prefix_user.sig = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 5;
DELETE FROM prefix_userfields WHERE fid = 5;

update prefix_user, prefix_userfields
SET prefix_user.sig = REPLACE(prefix_userfields.val, '/6_', '/')
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 6;
DELETE FROM prefix_userfields WHERE fid = 6;

update prefix_user, prefix_userfields
SET prefix_user.icq = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 7;
DELETE FROM prefix_userfields WHERE fid = 7;

update prefix_user, prefix_userfields
SET prefix_user.gebdatum = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 8;
DELETE FROM prefix_userfields WHERE fid = 8;

update prefix_user, prefix_userfields
SET prefix_user.geschlecht = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 9;
DELETE FROM prefix_userfields WHERE fid = 9;

update prefix_user, prefix_userfields
SET prefix_user.staat = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 10;
DELETE FROM prefix_userfields WHERE fid = 10;
  
update prefix_user, prefix_userfields
SET prefix_user.status = prefix_userfields.val
WHERE prefix_user.id = prefix_userfields.uid
  AND prefix_userfields.fid = 11;
DELETE FROM prefix_userfields WHERE fid = 11;

delete from prefix_profilefields where id <= 12;
update prefix_profilefields set func = 1 where func <> 6;
update prefix_profilefields set func = 2 where func = 6;

ALTER TABLE `prefix_profilefields` DROP `udel` ;
ALTER TABLE `prefix_profilefields` DROP `change` ;

INSERT INTO `prefix_profilefields` VALUES ('', 'msn', 12, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'opt_pm', 9, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'opt_mail', 8, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'yahoo', 13, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'sig', 6, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'wohnort', 4, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'icq', 11, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'gebdatum', 1, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'geschlecht', 2, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'staat', 0, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'status', 3, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'Kontakt', 7, 2);
INSERT INTO `prefix_profilefields` VALUES ('', 'aim', 14, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'homepage', 5, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'opt_pm_popup', 10, 3);
INSERT INTO `prefix_profilefields` VALUES ('', 'usergallery', 15, 3);