<?php
#   Copyright by Thomas Bowe [Funjoy]
#   Support webmaster@phpline.de
#   link www.k4d-clan.com

/* Module - Information
* -------------------------------------------------------
* Hier knnt ihr eure Module includieren lassen.
* Wenn Ihr selber Module zum Highlight programmiert 
* denkt daran das ihr auch noch das Parsen hier definieren msst.
* und in der bbcode_config.php Datei msstet ihr die Option auch noch einstellen.
* um ein Beispiel zu haben schaut euch die Funktion _htmlblock() am besten mal an.
* und in Zeile 308 und Zeile 490 habt ihr ein Beispiel wie ihr die Parsebefehle schreiben knnt.
*/

//> Bitte denkt daran das, dass Modul html.php immer unter dem Modul css.php sein muss.
//> Modul [css.php] 
	if(file_exists("include/includes/class/highlight/css.php")) {
		require_once("include/includes/class/highlight/css.php");
	}

//> Modul [html.php] 
	if(file_exists("include/includes/class/highlight/html.php")) {
		require_once("include/includes/class/highlight/html.php");
	}


class bbcode {
	//> Tags die geparsed werden drfen.
	var $permitted = array();
	
	//> Verschlsselte codeblocks.
	var $codecblocks = array();
	
	//> Informationen fr die Klasse!
	var $info = array();
	
	//> Patter befehle!
	var $pattern = array();
	
	//> Replace strings!
	var $replace = array();
	
	//> Smilies die in Grafik umgewandelt werden sollen.
	var $smileys = array();
	
	//> Codeblock verschlsseln und wieder ausgeben.
	function encode_codec($string,$tag) {
		$crypt = md5(count($this->codecblocks));
		$this->codecblocks[$crypt.":".$tag] = $string;
		return "[".$tag."]".$crypt."[/".$tag."]";
	}
	
	//> Codeblock entschlsseln und parsen!
	function _codeblock($codecid) {
		$string = $this->codecblocks[$codecid.':code'];
		$string = htmlentities($string);
		
		//> Zeilen zhlen.
		$lines = explode("\n",$string);
		
		for($no=1;$no<=count($lines);$no++) {
			$line .= "".$no.":<br />";
		}
		
		$string = str_replace("\t", '&nbsp; &nbsp;', $string);
		$string = str_replace('  ', '&nbsp; ', $string);
		$string = str_replace('  ', ' &nbsp;', $string);
		$string = nl2br($string);
		
		//> Hier knnt ihr den Header und Footer fr HTML editieren.
		$header = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"".$this->info['blockwidth']."\" align=\"center\"><tr><td width=\"".$this->info['blockwidth']."\" valgin=\"top\">"
				 ."<div style=\"overflow: auto; height: ".(37+(count($lines)*14))."px; width: 100%;\">"
				 ."<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"BORDER: 1px SOLID ".$this->info['block_bgcolor'].";\" width=\"100%\">"
				 ."<tr><td colspan=\"3\" style=\"font-family:Arial, Helvetica, sans-serif;FONT-SIZE:12px;FONT-WEIGHT:BOLD;COLOR:".$this->info['block_color'].";BACKGROUND-COLOR:".$this->info['block_bgcolor'].";\">&nbsp;Code</td></tr>"
				 ."<tr bgcolor=\"".$this->info['block_contentbgcolor']."\"><td style=\"color:".$this->info['block_color'].";padding-left:2px;padding-right:2px;border-right:1px solid ".$this->info['block_bgcolor'].";font-family:Arial, Helvetica, sans-serif;\" align=\"right\" width=\"20\" valign=\"top\"><code>"
				 .$line
				 ."</code></td><td width=\"5\">&nbsp;</td><td valign=\"top\" style=\"BACKGROUND-COLOR:".$this->info['block_contentbgcolor']."\" nowrap><code>";
		$footer = "</code></td></tr></table></div></td></tr></table>";
			
		return $header.stripslashes($string).$footer;
	}
	
	//> htmlblock entschlsseln und parsen!
	function _htmlblock($codecid) {
		$string = $this->codecblocks[$codecid.':html'];
		$string = htmlentities($string);
		
		//> Highlight Modul Funktion checken ob sie existerit.
		if(function_exists("highlight_html")) {
			$string = highlight_html($string);
		}
		
		//> Zeilen zhlen.
		$lines = explode("\n",$string);
		
		for($no=1;$no<=count($lines);$no++) {
			$line .= "".$no.":<br />";
		}
		
		$string = str_replace("\t", '&nbsp; &nbsp;', $string);
		$string = str_replace('  ', '&nbsp; ', $string);
		$string = str_replace('  ', ' &nbsp;', $string);
		$string = nl2br($string);
		
		//> Hier knnt ihr den Header und Footer fr HTML editieren.
		$header = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"".$this->info['blockwidth']."\" align=\"center\"><tr><td width=\"".$this->info['blockwidth']."\" valgin=\"top\">"
				 ."<div style=\"overflow: auto; height: ".(37+(count($lines)*14))."px; width: 100%;\">"
				 ."<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"BORDER: 1px SOLID ".$this->info['block_bgcolor'].";\" width=\"100%\">"
				 ."<tr><td colspan=\"3\" style=\"font-family:Arial, Helvetica, sans-serif;FONT-SIZE:12px;FONT-WEIGHT:BOLD;COLOR:".$this->info['block_color'].";BACKGROUND-COLOR:".$this->info['block_bgcolor'].";\">&nbsp;Html</td></tr>"
				 ."<tr bgcolor=\"".$this->info['block_contentbgcolor']."\"><td style=\"color:".$this->info['block_color'].";padding-left:2px;padding-right:2px;border-right:1px solid ".$this->info['block_bgcolor'].";font-family:Arial, Helvetica, sans-serif;\" align=\"right\" width=\"20\" valign=\"top\"><code>"
				 .$line
				 ."</code></td><td width=\"5\">&nbsp;</td><td valign=\"top\" style=\"BACKGROUND-COLOR:".$this->info['block_contentbgcolor'].";color:#000000;\" nowrap><code>";
		$footer = "</code></td></tr></table></div></td></tr></table>";
			
		return $header.$string.$footer;
	}
	
	//> cssblock entschlsseln und parsen!
	function _cssblock($codecid) {
		$string = $this->codecblocks[$codecid.':css'];
		$string = htmlentities($string);
		
		//> Highlight Modul Funktion checken ob sie existerit.
		if(function_exists("highlight_css")) {
			$string = highlight_css($string);
		}
		
		//> Zeilen zhlen.
		$lines = explode("\n",$string);
		
		for($no=1;$no<=count($lines);$no++) {
			$line .= "".$no.":<br />";
		}
		
		$string = str_replace("\t", '&nbsp; &nbsp;', $string);
		$string = str_replace('  ', '&nbsp; ', $string);
		$string = str_replace('  ', ' &nbsp;', $string);
		$string = nl2br($string);
		
		//> Hier knnt ihr den Header und Footer fr HTML editieren.
		$header = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"".$this->info['blockwidth']."\" align=\"center\"><tr><td width=\"".$this->info['blockwidth']."\" valgin=\"top\">"
				 ."<div style=\"overflow: auto; height: ".(37+(count($lines)*14))."px; width: 100%;\">"
				 ."<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"BORDER: 1px SOLID ".$this->info['block_bgcolor'].";\" width=\"100%\">"
				 ."<tr><td colspan=\"3\" style=\"font-family:Arial, Helvetica, sans-serif;FONT-SIZE:12px;FONT-WEIGHT:BOLD;COLOR:".$this->info['block_color'].";BACKGROUND-COLOR:".$this->info['block_bgcolor'].";\">&nbsp;CSS</td></tr>"
				 ."<tr bgcolor=\"".$this->info['block_contentbgcolor']."\"><td style=\"color:".$this->info['block_color'].";padding-left:2px;padding-right:2px;border-right:1px solid ".$this->info['block_bgcolor'].";font-family:Arial, Helvetica, sans-serif;\" align=\"right\" width=\"20\" valign=\"top\"><code>"
				 .$line
				 ."</code></td><td width=\"5\">&nbsp;</td><td valign=\"top\" style=\"BACKGROUND-COLOR:".$this->info['block_contentbgcolor'].";color:#000000;\" nowrap><code>";
		$footer = "</code></td></tr></table></div></td></tr></table>";
			
		return $header.$string.$footer;
	}
	
	//> phpblock entschlsseln und parsen!
	function _phpblock($codecid) {
		$string = $this->codecblocks[$codecid.':php'];
		
		//> Zeilen zhlen.
		$lines = explode("\n",$string);
		
		for($no=1;$no<=count($lines);$no++) {
			$line .= "".$no.":<br />";
		}
		
		ob_start();
   		highlight_string(trim(stripslashes($string)));
    	$php = ob_get_contents();
    	ob_end_clean();
		
		//> Hier knnt ihr den Header und Footer fr HTML editieren.
		$header = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"".$this->info['blockwidth']."\" align=\"center\"><tr><td width=\"".$this->info['blockwidth']."\" valgin=\"top\">"
				 ."<div style=\"overflow: auto; height: ".(37+(count($lines)*14))."px; width: 100%;\">"
				 ."<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"BORDER: 1px SOLID ".$this->info['block_bgcolor'].";\" width=\"100%\">"
				 ."<tr><td colspan=\"3\" style=\"font-family:Arial, Helvetica, sans-serif;FONT-SIZE:12px;FONT-WEIGHT:BOLD;COLOR:".$this->info['block_color'].";BACKGROUND-COLOR:".$this->info['block_bgcolor'].";\">&nbsp;PHP</td></tr>"
				 ."<tr bgcolor=\"".$this->info['block_contentbgcolor']."\"><td style=\"color:".$this->info['block_color'].";padding-left:2px;padding-right:2px;border-right:1px solid ".$this->info['block_bgcolor'].";font-family:Arial, Helvetica, sans-serif;\" align=\"right\" width=\"20\" valign=\"top\"><code>"
				 .$line
				 ."</code></td><td width=\"5\">&nbsp;</td><td valign=\"top\" style=\"BACKGROUND-COLOR:".$this->info['block_contentbgcolor']."\" nowrap><code>";
		$footer = "</code></td></tr></table></div></td></tr></table>";
			
		return $header.$php.$footer;
	}
	
	//> Smilies aus dem Array auslesen.
	function _smileys($string) {
		if(!is_null($this->smileys) && is_array($this->smileys)) {
			if($this->permitted['smileys'] == true) {
				foreach ($this->smileys as $icon => $info) {
					list($emo, $url) = explode('#@#-_-_-#@#', $info);
					$string = str_replace($icon,'<img src="include/images/smiles/'.$url.'" border="0" alt="'.$emo.'" title="'.$emo.'" />',$string);
				}
			}
			return $string;
		} else {
			return $string;
		}
	}
	
	//> Badwords Filtern.
	function _badwords($string) {
		if(file_exists("include/includes/class/badwords.csv")) {
			$file = file("include/includes/class/badwords.csv");
			foreach($file as $line) {
				$array = explode(":",$line);
				$pattern[] = "%".addcslashes($array[0],"[]{}%/$^()+.*\"\\")."%iU";
				$replace[] = $array[1];
			}
			
			$string = preg_replace($pattern,$replace,$string);
			return $string;
		} else {
			
			return $string;
		}
	}
	
	//> Liste formatieren.
	function _list($codecid) {
		$string = $this->codecblocks[$codecid.':list'];
		$array = explode("[*]",$string);
		for($no=1;$no<=(count($array)-1);$no++) {
			$li .= "<li>".$array[$no]."</li>";
		}
		
		return "<ul>".$li."</ul>";
	}
	
	//> Auf Maximale Schriftgre berprfen.
	function _size($size,$string) {
		$max = $this->info['max_fontsize'];			
		if($size <= $max) {
			$fontsize = "<span style=\"font-size:".$size."px\">$string</span>"; 
		} else {
			$fontsize = "<span style=\"font-size:".$max."px\">$string</span>";  
		}
			
		return $fontsize;
	}
	
	//> Bilder auf Maximale gren berprfen.
	function _img($string) {
		//> Information des Bildes Laden.
		$img_info = @getimagesize($string);  
		
		if(!is_numeric($img_info[0])) {
			$src = $this->info['max_img_width'].";".$this->info['max_img_height'].";".$string;
			$image = "<script type=\"text/javascript\" src=\"http://www.phpline.de/ilch/imginfo.php?info=".urlencode(base64_encode($src))."\"></script>";
		} else {
			if($img_info[1] <= $this->info['max_img_height'] && $img_info[0] <= $this->info['max_img_width']) {
				$image = "<img src=\"".$string."\" ".$img_info[3]." alt=\"\" title=\"\" border=\"0\">"; 
			} else {
				$img_width = $this->info['max_img_width'] / $img_info[0];
				$img_height = $this->info['max_img_height'] /$img_info[1];
				if($img_width < $img_height) {
					$new_width = $img_info[0] * $img_width;
					$new_height = $img_info[1] * $img_width;  
				} else {
					$new_width = $img_info[0] * $img_height;
					$new_height = $img_info[1] * $img_height;   
				}  
			
				$image = "<a href=\"".$string."\" target=\"_BLANK\"><img src=\"".$string."\" width=\"".sprintf("%00d",$new_width)."\" height=\"".sprintf("%00d",$new_height)."\" alt=\"\" title=\"\" border=\"0\"></a>"; 
			}
		}
		
		return $image;
	} 
	
	//> Screenshots darstellen.
	function _screenshot($string) {
		//> Information des Bildes Laden.
		$img_info = @getimagesize($string);  
		
		if(!is_numeric($img_info[0])) {
			$src = $this->info['max_screen_width'].";".$this->info['max_screen_height'].";".$string;
			$image = "<script type=\"text/javascript\" src=\"http://www.phpline.de/ilch/imginfo.php?info=".urlencode(base64_encode($src))."\"></script>";
		} else {
			if($img_info[1] <= $this->info['max_screen_height'] && $img_info[0] <= $this->info['max_screen_width']) {
				$image = "<img src=\"".$string."\" ".$img_info[3]." alt=\"\" title=\"\" border=\"0\">"; 
			} else {
				$img_width = $this->info['max_screen_width'] / $img_info[0];
				$img_height = $this->info['max_screen_height'] /$img_info[1];
				if($img_width < $img_height) {
					$new_width = $img_info[0] * $img_width;
					$new_height = $img_info[1] * $img_width;  
				} else {
					$new_width = $img_info[0] * $img_height;
					$new_height = $img_info[1] * $img_height;   
				}  
			
				$image = "<a href=\"".$string."\" target=\"_BLANK\"><img src=\"".$string."\" width=\"".sprintf("%00d",$new_width)."\" height=\"".sprintf("%00d",$new_height)."\" alt=\"\" title=\"\" border=\"0\"></a>"; 
			}
		}
	
		return $image;
	} 
	
	//> Zu lange Links krzen.
	function _shorturl($string,$http=null) {
		$count = strlen($string);
		
		if($count >= $this->info['max_url_length']) {
			$max_short_half = sprintf("%00d",($this->info['max_url_length']/2));
			$string = "<a href=\"".$http.$string."\" target=\"_BLANK\">".substr($string,0,$max_short_half)."...".substr($string,-$max_short_half)."</a>";
		} else {
			$string = "<a href=\"".$http.$string."\" target=\"_BLANK\">".$string."</a>";
		}
		
		return $string;
	}
	
	//> Zu lange Wrter krzen.
	function _shortwords($string) {
		//> Zeichenkette in einzelne Array elemente zerlegen.
		$lines = explode("\n",$string);
		
		//> Patter Befehle die nicht gekrzt werden drfen !!!
		$pattern = array("url1" => "%(www.[-a-zA-Z0-9@:;\%_\+.~#?&//=]+?)%",
						 "url2" => "%((http|https|ftp)://{1}[-a-zA-Z0-9@:;\%_\+.~#?&//=]+?)%");

		foreach($lines as $line) {
			$words = explode(" ",$line);
			foreach($words as $word) {
				if(strlen($word) > $this->info['max_word_length'] && !preg_match($pattern['url1'],$word) && !preg_match($pattern['url2'],$word)) {
					$string = str_replace($word,substr($word,0,($this->info['max_word_length'])-3)."...",$string);
				}
			}	
		}

		return $string;
	}
	
	function parse($string) {
		//> Die Blocks werden codiert um sie vor dem restlichen parsen zu schtzen.
		if($this->permitted['php'] == true) {
			$string = preg_replace("%\[php\](.+)\[\/php\]%esiU","\$this->encode_codec('\$1','php')",$string);
		}   
		
		if($this->permitted['html'] == true) {
			$string = preg_replace("%\[html\](.+)\[\/html\]%esiU","\$this->encode_codec('\$1','html')",$string);
		} 
		
		if($this->permitted['css'] == true) {
			$string = preg_replace("%\[css\](.+)\[\/css\]%esiU","\$this->encode_codec('\$1','css')",$string);
		} 
		
		if($this->permitted['code'] == true) {
			$string = preg_replace("%\[code\](.+)\[\/code\]%esiU","\$this->encode_codec('\$1','code')",$string);
		}   
		
		if($this->permitted['list'] == true) {
			$string = preg_replace("%\[list\](.+)\[\/list\]%esiU","\$this->encode_codec('\$1','list')",$string);
		}  
		
		//> BB Code der den Codeblock nicht betrifft.
		//> berprfen ob die wrter nicht die maximal lnge berschrieten.
		$string = $this->_shortwords($string);
		$string = htmlentities($string);
		$string = nl2br($string);
		
		if($this->permitted['url'] == true) {
			if($this->permitted['autourl'] == true) {
				//> Format: www.xxx.de
				$this->pattern[] = "%(( |\n|^)www.[-a-zA-Z0-9@:;\%_\+.~#?&//=]+?)%eUi";
				$this->replace[] = "\$this->_shorturl('\$1','http://')";
				
				//> Format: xxx.de
				$this->pattern[] = "%(( |\n|^)(http|https|ftp)://{1}[-a-zA-Z0-9@:;\%_\+.~#?&//=]+?)%eUi";
				$this->replace[] = "\$this->_shorturl('\$1')";
				
				//> Format xxx@xxx.de
				$this->pattern[] = "%(( |\n|^)[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,3})%i";
				$this->replace[] = "<a href=\"mailto:$1\">$1</a>";
			}
			
			//> Format: [url=www.xxx.de]xxx[/url]
			$this->pattern[] = "%\[url=(www.[-a-zA-Z0-9@:\%_\+.~#?&//=]+?)\](.+)\[\/url\]%Uis";  
			$this->replace[] = "<a href=\"http://$1\" target=\"_blank\">$2</a>";
			
			//> Format: [url=xxx.de]xxx[/url]
			$this->pattern[] = "%\[url=(.+)\](.+)\[\/url\]%Uis";
			$this->replace[] = "<a href=\"$1\" target=\"_blank\">$2</a>";
			
			//> Format: [url]www.xxx.de[/url]
			$this->pattern[] = "%\[url\](www.[-a-zA-Z0-9@:\%_\+.~#?&//=]+?)\[\/url\]%Uis";
			$this->replace[] = "\$this->_shorturl('\$1','http://')";
			
			//> Format: [url]xxx.de[/url]
			$this->pattern[] = "%\[url\](.+)\[\/url\]%esiU";
			$this->replace[] = "\$this->_shorturl('\$1')";
			
			//> Format: [mail]xxx@xxx.de[/mail]
			$this->pattern[] = "%\[mail\]([_\.0-9a-z-]+\@([0-9a-z]+)\.[a-z]{2,3})\[\/mail\]%Uis";
			$this->replace[] = "<a href=\"mailto:$1\">$1</a>";
			
			//> Format: [mail=xxx@xxx.de]xxx[/mail]
			$this->pattern[] = "%\[mail=([_\.0-9a-z-]+\@([0-9a-z]+)\.[a-z]{2,3})\](.+)\[\/mail\]%Uis";
			$this->replace[] = "<a href=\"mailto:$1\">$3</a>";
		}		
		
		//> Darf BB Code [B] dekodiert werden?
		if($this->permitted['b'] == true) {
			//> Format: [b]xxx[/b]
			$this->pattern[] = "%\[b\](.+)\[\/b\]%Uis";
			$this->replace[] = "<b>$1</b>";  
		}
		
		//> Darf BB Code [I] dekodiert werden?
		if($this->permitted['i'] == true) {
			//> Format: [i]xxx[/i]
			$this->pattern[] = "%\[i\](.+)\[\/i\]%Uis";
			$this->replace[] = "<i>$1</i>";  
		}
		
		//> Darf BB Code [U] dekodiert werden?
		if($this->permitted['u'] == true) {
			//> Format: [u]xxx[/u]
			$this->pattern[] = "%\[u\](.+)\[\/u\]%Uis";
			$this->replace[] = "<u>$1</u>";  
		}
		
		//> Darf BB Code [S] dekodiert werden?
		if($this->permitted['s'] == true) {
			//> Format: [s]xxx[/s]
			$this->pattern[] = "%\[s\](.+)\[\/s\]%Uis";
			$this->replace[] = "<strike>$1</strike>";  
		}
		
		
		###############################################
		
		
		//> Darf BB Code [LEFT] dekodiert werden?
		if($this->permitted['left'] == true) {
			//> Format: [left]xxx[/left]
			$this->pattern[] = "%\[left\](.+)\[\/left\]%Uis";
			$this->replace[] = "<div align=\"left\">$1</div>";
		}
		
		//> Darf BB Code [CENTER] dekodiert werden?
		if($this->permitted['center'] == true) {
			//> Format: [center]xxx[/center]
			$this->pattern[] = "%\[center\](.+)\[\/center\]%Uis";
			$this->replace[] = "<div align=\"center\">$1</div>";  
		}
		
		//> Darf BB Code [RIGHT] dekodiert werden?
		if($this->permitted['right'] == true) {
			//> Format: [right]xxx[/right]
			$this->pattern[] = "%\[right\](.+)\[\/right\]%Uis";
			$this->replace[] = "<div align=\"right\">$1</div>";  
		}
		
		
		###############################################
		
		//> Darf BB Code [EMPH] dekodiert werden?
		if($this->permitted['emph'] == true) {
			//> Format: [emph]xxx[/emph]
			$this->pattern[] = "%\[emph\](.+)\[\/emph\]%Uis";
			$this->replace[] = "<span style=\"background-color:#ffd500;\">$1</span>";  
		}
		
		//> Darf BB Code [COLOR] dekodiert werden?
		if($this->permitted['color'] == true) {
			//> Format: [color=#xxxxxx]xxx[/color]
			$this->pattern[] = "%\[color=(#{1}[0-9a-zA-Z]+?)\](.+)\[\/color\]%Uis";
			$this->replace[] = "<font color=\"$1\">$2</font>";  
		}
		
		//> Darf BB Code [SIZE] dekodiert werden?
		if($this->permitted['size'] == true) {
			//> Format: [size=xx]xxx[/size]
			$this->pattern[] = "%\[size=([0-9]+?)\](.+)\[\/size\]%eUi";
			$this->replace[] = "\$this->_size('\$1','\$2')";  
		}
		
		//> Darf BB Code [IMG] dekodiert werden?
		if($this->permitted['img'] == true) {
			//> Format: [img]xxx.de[/img]
			$this->pattern[] = "%\[img\]([-a-zA-Z0-9@:\%_\+.~#?&//=]+?)\[\/img\]%eUi";
			$this->replace[] = "\$this->_img('\$1')";  
		}
		
		//> Darf BB Code [SCREENSHOT] dekodiert werden?
		if($this->permitted['screenshot'] == true) {
			//> Format: [screenshot]xxx.de[/screenshot]
			$this->pattern[] = "%\[shot\]([-a-zA-Z0-9@:\%_\+.~#?&//=]+?)\[\/shot\]%eUi";
			$this->replace[] = "\$this->_screenshot('\$1')";  
		}
		
		###############################################
		
		
		//> Darf BB Code [QUOTE] dekodiert werden?
		if($this->permitted['quote'] == true) {
			//> Header und Footer fr Zitat.
			$header = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"BORDER: 1px SOLID ".$this->info['block_bgcolor'].";\" width=\"".$this->info['blockwidth']."\" align=\"center\">"
					 ."<tr><td style=\"font-family:Arial, Helvetica, sans-serif;FONT-SIZE:13px;FONT-WEIGHT:BOLD;COLOR:".$this->info['block_color'].";BACKGROUND-COLOR:".$this->info['block_bgcolor'].";\">&nbsp;Zitat</td></tr>"
					 ."<tr bgcolor=\"".$this->info['block_contentbgcolor']."\"><td><table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"98%\"><tr><td style=\"FONT-STYLE:ITALIC;FONT-SIZE:10px;COLOR:#666666;\">";
			
			$header2 = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"BORDER: 1px SOLID ".$this->info['block_bgcolor'].";\" width=\"".$this->info['blockwidth']."\">"
					 ."<tr><td style=\"font-family:Arial, Helvetica, sans-serif;FONT-SIZE:13px;FONT-WEIGHT:BOLD;COLOR:".$this->info['block_color'].";BACKGROUND-COLOR:".$this->info['block_bgcolor'].";\">&nbsp;Zitat von $1</td></tr>"
					 ."<tr bgcolor=\"".$this->info['block_contentbgcolor']."\"><td><table align=\"center\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"98%\"><tr><td style=\"FONT-STYLE:ITALIC;FONT-SIZE:10px;COLOR:#666666;\">";
			
			$footer = "</td></tr></table></td></tr></table>";  
			
			//> Format: [quot]xxx[/quot]
			$this->pattern[] = "%\[quote\](.+)\[\/quote\]%Uis";
			$this->replace[] = $header."$1".$footer;
			
			//> Format: [quot=xxx]xxx[/quot]
			$this->pattern[] = "%\[quote=(.+)\](.+)\[\/quote\]%Uis";
			$this->replace[] = $header2."$2".$footer;
		}
		
		//> String parsen
		$string = preg_replace($this->pattern,$this->replace,$string);
		
		//> Badwors Filtern.
		$string = $this->_smileys($string);
		
		//> Zum schluss die blcke die verschlsselt wurden wieder entschlsseln und Parsen.
		if($this->permitted['php'] == true) {
			$string = preg_replace("%\[php\](.+)\[\/php\]%esiU","\$this->_phpblock('\$1')",$string);  
		}
		
		if($this->permitted['html'] == true) {
			$string = preg_replace("%\[html\](.+)\[\/html\]%esiU","\$this->_htmlblock('\$1')",$string);  
		}
		
		if($this->permitted['code'] == true) {
			$string = preg_replace("%\[code\](.+)\[\/code\]%esiU","\$this->_codeblock('\$1')",$string);  
		}
			
		if($this->permitted['list'] == true) {
			$string = preg_replace("%\[list\](.+)\[\/list\]%esiU","\$this->_list('\$1')",$string);
		} 
		
		//> Badwors Filtern.
		$string = $this->_badwords($string);
		
		unset($this->pattern);
		unset($this->replace);
		
		return $string;
	}
}
?>